/* REXX */

say
say "Creating/updating WPS objects for NFTP"
say

/* Load RexxUtil extensions */

if RxFuncQuery("SysLoadFuncs") then do
    call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    if result \= "0" then do
        say "error loading RexxUtil.dll"
        exit
    end
    call SysLoadFuncs
end

/* analyze arguments */

parse arg destpath .
if destpath = "" then destpath = directory()

foldername = "<NFTP_FOLDER>"

/* creating folder */

settings = 'OBJECTID='foldername';ICONFILE='destpath'\nftp-fld.ico'
rc = SysCreateObject('WPFolder', 'NFTP', '<WP_DESKTOP>', settings, 'update')
if rc != 1 then say "Cannot create NFTP folder"
else            say "NFTP folder                 has been created/updated"

/* creating WPS objects */

settings = 'EXENAME='destpath'\nftp.cmd;PARAMETERS=[FTP server to log in?];PROGTYPE=WINDOWABLEVIO;NOAUTOCLOSE=YES;MINIMIZED=NO;ICONFILE=nftp.ico'
rc = SysCreateObject('WPProgram', 'NFTP', foldername, settings, 'replace')
if rc != 1 then say "Cannot create NFTP object"
else            say "NFTP object                 has been created/updated"

settings = 'EXENAME=E.EXE;PARAMETERS='destpath'\nftp.bmk;'
rc = SysCreateObject('WPProgram', 'Edit bookmarks', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'Edit bookmarks' object"
else            say "'Edit bookmarks' object     has been created/updated"

settings = 'EXENAME=E.EXE;PARAMETERS='destpath'\nftp.ini;'
rc = SysCreateObject('WPProgram', 'Edit NFTP.INI', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'Edit NFTP.INI' object"
else            say "'Edit NFTP.INI' object      has been created/updated"

settings = 'EXENAME=explore.exe;PARAMETERS=-q nftp-man.htm;STARTUPDIR='destpath';PROGTYPE=PM;MINIMIZED=NO;ICONFILE=nftp-man.ico'
rc = SysCreateObject('WPProgram', 'NFTP manual', foldername, settings, 'replace')
if rc != 1 then say "Cannot create documentation object"
else            say "Documentation object        has been created/updated"

settings = 'EXENAME=explore.exe;PARAMETERS=-q nftpkeys.htm;STARTUPDIR='destpath';PROGTYPE=PM;MINIMIZED=NO;ICONFILE=nftp-man.ico'
rc = SysCreateObject('WPProgram', 'Keyboard reference', foldername, settings, 'replace')
if rc != 1 then say "Cannot create documentation object"
else            say "Documentation object        has been created/updated"

settings = 'EXENAME=explore.exe;PARAMETERS=-q history.htm;STARTUPDIR='destpath';PROGTYPE=PM;MINIMIZED=NO;ICONFILE=nftp-man.ico'
rc = SysCreateObject('WPProgram', 'History of changes', foldername, settings, 'replace')
if rc != 1 then say "Cannot create documentation object"
else            say "Documentation object        has been created/updated"

settings = 'EXENAME='destpath'\stat.cmd;STARTUPDIR='destpath';PARAMETERS=nftp.fls;PROGTYPE=WINDOWABLEVIO;NOAUTOCLOSE=YES;MINIMIZED=NO;ICONFILE=nftp.ico'
rc = SysCreateObject('WPProgram', 'Gather statistics', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'Gather statistics' object"
else            say "'Gather statistics' object  has been created/updated"

settings = 'EXENAME=E.EXE;PARAMETERS='destpath'\nftp.sta;'
rc = SysCreateObject('WPProgram', 'View statistics', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'View statistics' object"
else            say "'View statistics' object    has been created/updated"

settings = 'EXENAME=E.EXE;PARAMETERS='destpath'\regform.txt;'
rc = SysCreateObject('WPProgram', 'Registration form', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'Registration form' object"
else            say "'Registration form' object  has been created/updated"

settings = 'EXENAME=E.EXE;PARAMETERS='destpath'\order.frm;'
rc = SysCreateObject('WPProgram', 'BMT Micro registration form', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'BMT Micro registration form' object"
else            say "'BMT Micro registration form' object  has been created/updated"

settings = 'EXENAME='destpath'\PURCHASE.EXE;STARTUPDIR='destpath';PROGTYPE=PM;MINIMIZED=NO;ICONFILE=purchase.ico'
rc = SysCreateObject('WPProgram', 'Register via BMT Micro', foldername, settings, 'replace')
if rc != 1 then say "Cannot create 'Register via BMT Micro' object"
else            say "'Register via BMT Micro' object  has been created/updated"

return
